<?php
// recibir_gps.php

// Configura tu conexión a la base de datos aquí
$host = "15.204.129.121";
$user = "liderplus";
$pass = "LiderPlus*2022";
$dbname = "erp_liderplus";

$conn = new mysqli($host, $user, $pass, $dbname);
if ($conn->connect_error) {
    http_response_code(500);
    echo json_encode(["error" => "Error de conexión a la base de datos"]);
    exit;
}

// Obtiene el JSON recibido en el cuerpo de la petición POST
$json = file_get_contents('php://input');
$data = json_decode($json, true);

if (!$data || !isset($data['thistorial_gps'])) {
    http_response_code(400);
    echo json_encode(["error" => "JSON inválido o datos faltantes"]);
    exit;
}

$gpsRecords = $data['thistorial_gps'];

$stmt = $conn->prepare("INSERT INTO thistorial_gps (cserial, nlongitud, nlatitud, nprecision, nhora_gps, cproveedor) VALUES (?, ?, ?, ?, ?, ?)");

// Verifica si se preparó bien la consulta
if (!$stmt) {
    http_response_code(500);
    echo json_encode(["error" => "Error preparando la consulta: " . $conn->error]);
    exit;
}

foreach ($gpsRecords as $record) {
    // Asegúrate de validar o sanitizar los datos si es necesario
    $cserial = $record['cserial'];
    $nlongitud = $record['nlongitud'];
    $nlatitud = $record['nlatitud'];
    $nprecision = $record['nprecision'];
    $nhora_gps = $record['nhora_gps'];
    $cproveedor = $record['cproveedor'];

    $stmt->bind_param("sdddss", $cserial, $nlongitud, $nlatitud, $nprecision, $nhora_gps, $cproveedor);

    if (!$stmt->execute()) {
        http_response_code(500);
        echo json_encode(["error" => "Error insertando datos: " . $stmt->error]);
        $stmt->close();
        $conn->close();
        exit;
    }
}

$stmt->close();
$conn->close();

http_response_code(200);
echo json_encode(["success" => "Datos GPS insertados correctamente"]);
?>
